function [cp,cd] = SegmentClosestPoint( c, p, q )
% cp = TriangleClosestPoint(c,p,q,r)
%
% Find the point on the triangle (p,q,r) that is closest to point c
%
% 
% Copyright (C) Russell H. Taylor 2013
% For use with CIS I only
% Do not redistribute without written permission from Russell Taylor

    qp = q-p;
    lambda = (c-p)*qp/(qp*qp);
    if lambda<=0 
        cp = p;
    elseif lambda>=1
        cp = q;
    else
        cp = p+qp*lambda;
    end
    cd = norm(c-cp);
end

